<?php //۞//text{encoding:utf-8;bom:no;linebreaks:unix;tabs:4;}
$plogger_version = 1.5;

/*
	All-new all-in-one plogging!

	*/

/*
	Plogger

	Plogger logs data "pairs" into a "flat file" array database.

	The plog_show() function (below) pulls them out again. I had need of
	this function in my logger, to log referers hitting my site from
	indside copies of corzblog. My admin page picks them up and displays
	them using plogshow, along with lots of other stuff, of course.

	The pairs are 1: mixed (whatever you like)  2: integer (number)

	You can use whatever you want for the first value. The second is
	a counter, and it simply increases every time another of the first
	value is added, though it would be easy to change. As would the number
	of values, you could have triplets! Plog is a "multiple item counter"!

	This code originated in corz distro machine, used for counting
	downloads, one obvious use of plogger.

	You could, of course, put put arrays inside the first value, even
	multi-dimensional arrays, I guess. plogger will count 'em.

	;o) Cor

	(c) copyright corz.org 2000->today
*/


function log_pair($plog_file, $value, $remove=false) {

	$return = 0;

	// create new plog file, if required..
	//if (!file_exists($plog_file)) file_put_contents($plog_file, ''); // php5 only. handy.
	if (!file_exists($plog_file)) {
		$fp = @fopen($plog_file, 'wb');
		@fwrite ($fp, '');
		@fclose ($fp);
	}

	$old_pairs = '';

	/*
	get the "serialized" array pairs from the file..	*/
	if (file_exists($plog_file)) {
		if ($fp = fopen($plog_file, 'rb')) {
			$lock = flock($fp, LOCK_SH);
			if ($lock) {
				$all_pairs = @fread($fp, filesize($plog_file));// @ could be a new file
				$lock = flock($fp, LOCK_UN);
			}
			fclose($fp);
			clearstatcache();
		}
		$old_pairs = unserialize($all_pairs);
	}

	if (is_array($old_pairs)) { // might be a new file

		// run through the old pairs, add a score to our match, if any..
		while (list($key, $val) = each($old_pairs)) {

			if ($key == $value) {
				if ($remove) {
					unset($old_pairs[$key]);
				} else {
					$old_pairs[$key] += 1;
				}
			}
		}

		// first time for this value, begin counting..
		if (!$remove and !array_key_exists($value, $old_pairs)) {
			$new_pair = array($value => 1);
			/* add to the existing pairs.. */
			$old_pairs = array_merge($old_pairs, $new_pair);
			$return = 'new';
		}

	} else {

		// first ever recorded pair..
		$old_pairs = array($value => 1);
		$return = 'new';
	}

	/*	write out the updated "pairs"..	*/

	if (is_writable($plog_file)) {

		// option: if filesize > so-an-so, archive the plog, or else..  //2do
		// rename to $arc_dir.$plog_file.date();		// $arc_dir = './'; //default (in prefs)
		// create new file..
		$sa = serialize($old_pairs);

		if ($fp = fopen($plog_file, 'wb')) {
			$lock = flock($fp, LOCK_EX);
			if ($lock) {
				fputs($fp, $sa);
				$lock = flock($fp, LOCK_UN);
			}
			fclose($fp);
			clearstatcache();
			$return = true;
		}
	} else {
		return $return;
	}
}



/*
	Plogshow v1.3

	New for 1.3: output is now Strict XHTML 1.0

	The plog_show() function pulls data "pairs" from flat file array
	databases created with the plogger function (above)

	See above for more information.
	plog_show can only handle simple strings and integers

	Plogshow outputs in its own 2-column div, so you can slot it in
	wherever you like, again, easy enough to change..

	;o)
	(or

	(c) 2004 corz.org
*/

/*
function plog_show($plog_file)	*/
function plog_show($plog_file, $admin=true) {

	$dirs = explode('/',$plog_file);
	$file_loc = '/'.$dirs[count($dirs)-2].'/'.$dirs[count($dirs)-1];

	if ($admin) {

echo '
<script>
//<![CDATA[
<!--
function del(file,go) {
	if ( confirm("\nreally remove " + file + " from list?\n") ) window.location = go;
}
//-->
//]]>
</script>
<noscript><!-- delete confirmation - JavaScript only --></noscript>';

	}
	echo '
<div class="two-column plog">
		<strong>plog from ',$file_loc,'..</strong>

		<div class="left-column">
			<span class="underline">data</span>
		</div>

		<div class="right-column">
			<span class="underline">score</span>
		</div>';

	if (file_exists($plog_file)) {

		if ($fp = fopen($plog_file, 'rb')) {
			$lock = flock($fp, LOCK_SH);
			if ($lock) {
				$all_pairs = @fread($fp, filesize($plog_file)); // @ could be a new file
				$lock = flock($fp, LOCK_UN);
			}
			fclose($fp);
			clearstatcache();
		}
		$old_pairs = @unserialize($all_pairs);

		if (is_array($old_pairs)) {
			arsort($old_pairs);
			while (list($key, $val) = each($old_pairs)) {

				$display = htmlentities(nice_chop($key, 38, 46));

				if ($admin) {
				echo "
		<div class=\"left-column\">
			<small><a href=\"javascript:del('",$key,"','",$_SERVER['PHP_SELF'],"?del="
			,$key,"')\" title=\"REMOVE\n",$key," from list\">",$display,"</a></small>";

				} else {
				echo '
		<div class="high-light">
		<div class="left-column"><small>',$display,'</small>';
				}

			echo go_link($key, $plog_file);
			echo '
		</div>';


				echo '
		<div class="right-column">',$old_pairs[$key],'</div>
		</div>';
			}
		}
	}
	echo '
</div>';
}/* end function plog_show()
*/


// if the plog is a link, or a search hit, make an anchor for it..
function go_link($string, $plog_file='') {
	$make_link = false;
	if (substr($string, 0, 7) == 'http://') {
		$href =  str_replace(" ", '%20;', $string);
		$make_link = true;
	} else {
		switch (true) {
			case stristr($plog_file, 'google'):
				$href = 'http://www.google.com/search?q='.rawurlencode($string);
				$make_link = true;
				break;
			case stristr($plog_file, 'yahoo'):
				$href = 'http://search.yahoo.com/search?p='.rawurlencode($string);
				$make_link = true;
				break;
			case stristr($plog_file, 'live'):
				$href = 'http://search.live.com/results.aspx?q='.rawurlencode($string);
				$make_link = true;
				break;
			break;
		}
	}

	if ($make_link) {
		return '&nbsp;&nbsp;&nbsp;<a href="'.htmlentities($href).
	'" title="Go there now! (drag into an empty tab to NOT send referrer information)">go!</a>';
	}
}


/*
	takes a long string a chops it in a "nice" way, removing the middle part
	so both ends are still legible. you can define the maximum length of both
	parts of the string. The middle section is replaced with "..."
*/
function nice_chop($tring, $startlen=64, $endlen=32) {
	if (strlen($tring) > ($startlen + $endlen)) {
		$tring = substr($tring, 0, $startlen).'...'.substr($tring, -$endlen);
	}
	return $tring;
}


?>